<?php
/**********************************************************************
 *  AWeber OAuth2 callback for “Traffic Magnet”
 *  – Exchanges ?code= for refresh‑ & access‑tokens
 *  – Saves them to aweber_tokens.json (alongside this file)
 *
 *  One‑time authorisation URL (paste into your browser):
 *  https://auth.aweber.com/oauth2/authorize?response_type=code&
 *      client_id=XIH6H4pA1MtzwJ3dEnGUP4pePZdijdiM&
 *      redirect_uri=https%3A%2F%2Flifestyletips.club%2Faweber_oauth_callback.php&
 *      scope=subscriber.write%20subscriber.read-extended
 *********************************************************************/

declare(strict_types=1);

/* ── App credentials ─────────────────────────────────────────── */
const CLIENT_ID     = 'XIH6H4pA1MtzwJ3dEnGUP4pePZdijdiM';
const CLIENT_SECRET = 'zyRwmbaAffpVWrzIgIxYiDfYurpXctag';
const REDIRECT_URI  = 'https://lifestyletips.club/aweber_oauth_callback.php';
const TOKENS_FILE   = __DIR__ . '/aweber_tokens.json';

/* ── Require ?code= ───────────────────────────────────────────── */
if (!isset($_GET['code'])) {
    http_response_code(400);
    exit('Missing ?code parameter from AWeber.');
}

/* ── Exchange code for tokens ────────────────────────────────── */
$ch = curl_init('https://auth.aweber.com/oauth2/token');
curl_setopt_array($ch, [
    CURLOPT_USERPWD        => CLIENT_ID . ':' . CLIENT_SECRET,
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => http_build_query([
        'grant_type'   => 'authorization_code',
        'code'         => $_GET['code'],
        'redirect_uri' => REDIRECT_URI
    ]),
    CURLOPT_RETURNTRANSFER => true
]);
$tok = json_decode(curl_exec($ch), true);
curl_close($ch);

if (empty($tok['access_token'])) {
    http_response_code(500);
    exit('OAuth token exchange failed: ' . print_r($tok, true));
}

/* ── Add helper expiry field and persist ─────────────────────── */
$tok['expires_at'] = time() + ($tok['expires_in'] ?? 7200);
file_put_contents(TOKENS_FILE, json_encode($tok, JSON_PRETTY_PRINT));

echo '<h2>✅  AWeber connection established!</h2>
      <p>You can now close this tab and test the form.</p>';
